/*:ja
 * @plugindesc (v.1.0) ウィンドウスキンの代わりにメッセージの背後に画像を表示します。
 * @url http://galvs-scripts.com
 * @target MZ
 * @author Galv
 * 
 * @help
 * 翻訳:ムノクラ
 * https://fungamemake.com/
 * https://twitter.com/munokura/
 * 
 * 元プラグイン:
 * https://galvs-scripts.com/2020/10/18/mz-message-background/
 * 
 *   Galv's Message Background MZ
 * ----------------------------------------------------------------------------
 * /img/system/ の画像を使って、
 * ウィンドウスキンを使わずにデフォルトのメッセージボックスの後ろに表示します。
 *
 * このプラグインに必要なサンプル画像は下記のMASTER DEMO内にあります。
 * https://galvs-scripts.com/rpgmaker/rmmz-plugins/
 * 
 * メッセージの背景画像には、特定の方法で名前を付ける必要があります。
 * /img/system/msgimg_X.png - Xはゲーム中に変更できる数字です。
 * デフォルトは msgimg_0.png です。
 *
 * この画像は3つのセクションに分かれています。
 * 
 *      ----------------------------
 *     |                            |
 *     |メッセージボックス上部      |      // 中か下の時表示
 *     |                            |
 *      ----------------------------
 *     |                            |
 *     |メッセージボックス          |      // 全位置表示
 *     |                            |
 *      ----------------------------
 *     |                            |
 *     |メッセージボックス下部      |      // 中か上の時表示
 *     |                            |
 *      ----------------------------
 * 
 * グラフィックの中央の「メッセージボックス」の部分は、
 * メッセージテキストの下に表示されます。
 * 他の2つの部分は、
 * メッセージウィンドウの位置に応じて表示されます。
 * メッセージウィンドウが一番上にある場合、
 * 「メッセージボックス上部」は画面外に表示されます。
 * メッセージウィンドウが一番下にある場合、
 * 「メッセージボックス下部」ウィンドウは画面外に表示されます。
 * どちらもメッセージは中央では表示されます。
 * 
 * 「文章の表示：背景」設定の「ウィンドウ」「暗くする」「透明」は、
 * メッセージの背景画像に影響を与えます。
 * ウィンドウは画像を正常に表示し、暗くするは画像を部分的に透明に表示し、
 * 透明は画像を見えなくします。
 * 
 * ----------------------------------------------------------------------------
 *  スクリプト
 * ----------------------------------------------------------------------------
 * 
 *     Galv.MBG.status(x);  // x は true または false を指定します。
 *                          // true はメッセージの背景を表示します。
 *                          // false は非表示にしてメッセージを通常表示します。
 * 
 *     Galv.MBG.id(X);          // Xは/img/system/msgimg_X.pngから
 *                              // 画像を決定するためのIDです。
 * 
 * ----------------------------------------------------------------------------
 * 例:
 * Galv.MBG.status(false);   // メッセージの背景をオフにします。
 * Galv.MBG.id(2);           // /img/system/msgimg_2.png の画像を使用します。
 * 
 * @param defaultStatus
 * @text デフォルト有効化
 * @desc true:プラグインのデフォルトは有効 / false:無効になります。無効の場合、スクリプトを使用してゲーム中に使用します。
 * @type boolean
 * @on 有効
 * @off 無効
 * @default true
 */
Galv.MBG.defaultOnOff = PluginManager.parameters("GALV_MessageBackgroundMZ")["defaultStatus"] == "true";
Galv.MBG.disable = false;

Galv.MBG.status = function(status) {
	$gameSystem._msgBackground.status = status;
};

Galv.MBG.id = function(id) {
	$gameSystem._msgBackground.id = id;
};
	

// GAME SYSTEM
//-----------------------------------------------------------------------------

Galv.MBG.Game_System_initialize = Game_System.prototype.initialize;
Game_System.prototype.initialize = function() {
	Galv.MBG.Game_System_initialize.call(this);
	this._msgBackground = {
		id: 0,
		status: Galv.MBG.defaultOnOff
	};
};


// SCENE BASE
//-----------------------------------------------------------------------------
Scene_Base.prototype.createMsgBackground = function() {
	Galv.MBG.disable = false;
	this._msgBgSprite = new Sprite_GalvMsgBg();
	this._msgBgSprite.z = -1000;
	this.addChild(this._msgBgSprite);
	Galv.MBG.Scene_Battle_createWindowLayer.call(this);
};


// SCENE MAP
//-----------------------------------------------------------------------------

Galv.MBG.Scene_Map_createWindowLayer = Scene_Map.prototype.createWindowLayer;
Scene_Map.prototype.createWindowLayer = function() {
	this.createMsgBackground();
	Galv.MBG.Scene_Map_createWindowLayer.call(this);
};


// SCENE BATTLE
//-----------------------------------------------------------------------------

Galv.MBG.Scene_Battle_createWindowLayer = Scene_Battle.prototype.createWindowLayer;
Scene_Battle.prototype.createWindowLayer = function() {
	this.createMsgBackground();
	Galv.MBG.Scene_Battle_createWindowLayer.call(this);
};


// SCENE MESSAGE
//-----------------------------------------------------------------------------

Galv.MBG.Scene_Message_createMessageWindow = Scene_Message.prototype.createMessageWindow;
Scene_Message.prototype.createMessageWindow = function() {
	Galv.MBG.Scene_Message_createMessageWindow.call(this);
	if (this._msgBgSprite) this._msgBgSprite.setWindow(this._messageWindow);
};


// WINDOW MESSAGE
//-----------------------------------------------------------------------------

// WINDOW MESSAGE START MESSAGE - MOD
Galv.MBG.Window_Message_startMessage = Window_Message.prototype.startMessage;
Window_Message.prototype.startMessage = function() {
	// Create graphic when window is displayed
	if (Galv.Mstyle.target) {
		Galv.MBG.disable = true;
	} else {
		Galv.MBG.disable = false;
	};
	Galv.MBG.Window_Message_startMessage.call(this);
};

// WINDOW MESSAGE SET BACKGROUND TYPE
Galv.MBG.Window_Message_setBackgroundType = Window_Message.prototype.setBackgroundType;
Window_Message.prototype.setBackgroundType = function(type) {
	// Compatibility with Message Styles plugin
	if (Galv.Mstyle.target) {
		this.opacity = 255;
	} else if ($gameSystem._msgBackground.status) {
		this.opacity = 0;
		this.hideBackgroundDimmer();
		return;
	};
	Galv.MBG.Window_Message_setBackgroundType.call(this,type);
};


// WINDOW NAMEBOX
//-----------------------------------------------------------------------------

Galv.MBG.Window_NameBox_setBackgroundType = Window_NameBox.prototype.setBackgroundType;
Window_NameBox.prototype.setBackgroundType = function(type) {
	// Compatibility with Message Styles plugin
	if (Galv.Mstyle.target) {
		this.opacity = 255;
	} else if ($gameSystem._msgBackground.status) {
		this.opacity = 0;
		this.hideBackgroundDimmer();
		return;
	};
	Galv.MBG.Window_NameBox_setBackgroundType.call(this,type);
};


// SPRITE GALVMSGBG
//-----------------------------------------------------------------------------

function Sprite_GalvMsgBg() {
    this.initialize.apply(this, arguments);
}

Sprite_GalvMsgBg.prototype = Object.create(Sprite.prototype);
Sprite_GalvMsgBg.prototype.constructor = Sprite_GalvMsgBg;

Sprite_GalvMsgBg.prototype.initialize = function() {
	Sprite.prototype.initialize.call(this);
	this.opacity = 0;
	this.loadBitmap();
	this.update();
};

Sprite_GalvMsgBg.prototype.setWindow = function(messageWindow) {
	this._messageWindow = messageWindow;
};

Sprite_GalvMsgBg.prototype.update = function() {
	Sprite.prototype.update.call(this);
	if (this._messageWindow) {
		this.controlBitmap();
		this.repositionSprite();
	};
};

Sprite_GalvMsgBg.prototype.loadBitmap = function() {
	this.imageID = $gameSystem._msgBackground.id;
    this.bitmap = ImageManager.loadSystem('msgimg_' + this.imageID);
	this.x = 0
	this.z = 10;
	this.maxopac = 255;
};

Sprite_GalvMsgBg.prototype.controlBitmap = function() {
	if (this.imageID != $gameSystem._msgBackground.id && !this._messageWindow.isClosing()) this.loadBitmap();  // If image changed, reload bitmap
	if (!$gameSystem._msgBackground.status || this._messageWindow.openness <= 0 || Galv.MBG.disable) {
		this.opacity = 0;
		this.maxopac = 255;
		return;
	};

	// Control image opacity
	switch ($gameMessage.background()) {
	case 0:
	// Window
		this.opacity = Math.min(this._messageWindow._openness,this.maxopac);
		break;
	case 1:
	// Dim
		this.opacity = this._messageWindow._openness * 0.5;
		this.maxopac = this.opacity;
		break;
	case 2:
	// Transparent
		this.opacity = 0;
		this.maxopac = 0;
		break;
	};
};

Sprite_GalvMsgBg.prototype.repositionSprite = function() {
	// center on message window vertically (image is in 3 equal sections)
	this.y = this._messageWindow.y - this.height / 3;
};